<?php

use yii\helpers\Html;
use app\models\User;

$this->title = 'Сражения';
?>

<div class="feedback">
    <?php echo $this->title; ?>
</div>

<div class="content">
    <?php if (empty($battles)): ?>
        Сражения отсутствуют
    <?php else: ?>
        <?php foreach ($battles as $battle): ?>
            <div class="feedback" style="text-align: left;">
                <table width="100%;">
                    <tr>
                        <td width="10%">
                            <img src="/images/cup.png" width="46">
                        </td>
                        <td width="90%">
                            <a href="/battle/lobby/<?php echo $battle->id; ?>">
                                <?php echo Html::encode($battle->name) ?>
                                <?php if ($battle->time > time()): ?>
                                    <span class="tgray" style="font-size: 12px;">
                                        <?php echo Yii::$app->formatter->format($battle->time, 'relativeTime'); ?>
                                    </span>
                                <?php elseif ($battle->time <= time() && $battle->time >= (time() - 3600)): ?>
                                    <span class="tred" style="font-size: 12px;">
                                        Идёт сражение
                                    </span>
                                <?php else: ?>
                                    <span class="tgray" style="font-size: 12px;">
                                        сражение окончено
                                    </span>
                                <?php endif; ?>
                            </a>
                        </td>
                    </tr>
                </table>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>

</div>
